@echo off
:: https://privacy.sexy — v0.13.8 — Sat, 11 Oct 2025 16:24:24 GMT
:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: Remove "DirectX Configuration Database" capability (revert)
echo --- Remove "DirectX Configuration Database" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'DirectX.Configuration.Database*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----Remove "Internet Explorer 11" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "Internet Explorer 11" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Browser.InternetExplorer*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "Math Recognizer" capability (revert)-------
:: ----------------------------------------------------------
echo --- Remove "Math Recognizer" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'MathRecognizer*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "OneSync" capability (breaks Mail, People, and Calendar) (revert)
echo --- Remove "OneSync" capability (breaks Mail, People, and Calendar) (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'OneCoreUAP.OneSync*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "OpenSSH client" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "OpenSSH client" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'OpenSSH.Client*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "PowerShell ISE" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "PowerShell ISE" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Microsoft.Windows.PowerShell.ISE*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --Remove "Print Management Console" capability (revert)---
:: ----------------------------------------------------------
echo --- Remove "Print Management Console" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Print.Management.Console*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --------Remove "Quick Assist" capability (revert)---------
:: ----------------------------------------------------------
echo --- Remove "Quick Assist" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'App.Support.QuickAssist*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "Steps Recorder" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "Steps Recorder" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'App.StepsRecorder*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----Remove "Windows Fax and Scan" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "Windows Fax and Scan" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Print.Fax.Scan*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove ".NET Framework" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove ".NET Framework" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'NetFX3*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --------Remove "Mixed Reality" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "Mixed Reality" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Analog.Holographic.Desktop*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Remove "Wireless Display" capability (revert)-------
:: ----------------------------------------------------------
echo --- Remove "Wireless Display" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'App.WirelessDisplay.Connect*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Accessibility - Braille Support" capability (revert)
echo --- Remove "Accessibility - Braille Support" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Accessibility.Braille*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "Developer Mode" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "Developer Mode" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Tools.DeveloperMode.Core*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "Graphics Tools" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "Graphics Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Tools.Graphics.DirectX*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------------Remove "IrDA" capability (revert)-------------
:: ----------------------------------------------------------
echo --- Remove "IrDA" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Network.Irda*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----Remove "Microsoft WebDriver" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "Microsoft WebDriver" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Microsoft.WebDriver*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -Remove "MSIX Packaging Tool Driver" capability (revert)--
:: ----------------------------------------------------------
echo --- Remove "MSIX Packaging Tool Driver" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Msix.PackagingTool.Driver*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Remove "OpenSSH Server" capability (revert)--------
:: ----------------------------------------------------------
echo --- Remove "OpenSSH Server" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'OpenSSH.Server*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Windows Emergency Management Services and Serial Console" capability (revert)
echo --- Remove "Windows Emergency Management Services and Serial Console" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Windows.Desktop.EMS-SAC.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---------Remove "XPS Viewer" capability (revert)----------
:: ----------------------------------------------------------
echo --- Remove "XPS Viewer" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'XPS.Viewer*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Remove "Enterprise Cloud Print" capability (revert)----
:: ----------------------------------------------------------
echo --- Remove "Enterprise Cloud Print" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Print.EnterpriseCloudPrint*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----Remove "Mopria Cloud Service" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "Mopria Cloud Service" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Print.MopriaCloudService*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Active Directory Domain Services and Lightweight Directory Services Tools" capability (revert)
echo --- Remove "Active Directory Domain Services and Lightweight Directory Services Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.ActiveDirectory.DS-LDS.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "BitLocker Drive Encryption Administration Utilities" capability (revert)
echo --- Remove "BitLocker Drive Encryption Administration Utilities" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.BitLocker.Recovery.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Active Directory Certificate Services Tools" capability (revert)
echo --- Remove "Active Directory Certificate Services Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.CertificateServices.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Remove "DHCP Server Tools" capability (revert)------
:: ----------------------------------------------------------
echo --- Remove "DHCP Server Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.DHCP.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Remove "DNS Server Tools" capability (revert)-------
:: ----------------------------------------------------------
echo --- Remove "DNS Server Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.Dns.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --Remove "Failover Clustering Tools" capability (revert)--
:: ----------------------------------------------------------
echo --- Remove "Failover Clustering Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.FailoverCluster.Management.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----Remove "File Services Tools" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "File Services Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.FileServices.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Group Policy Management Tools" capability (revert)
echo --- Remove "Group Policy Management Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.GroupPolicy.Management.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "IP Address Management (IPAM) Client" capability (revert)
echo --- Remove "IP Address Management (IPAM) Client" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.IPAM.Client.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Data Center Bridging LLDP Tools" capability (revert)
echo --- Remove "Data Center Bridging LLDP Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.LLDP.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Network Controller Management Tools" capability (revert)
echo --- Remove "Network Controller Management Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.NetworkController.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: Remove "Network Load Balancing Tools" capability (revert)-
:: ----------------------------------------------------------
echo --- Remove "Network Load Balancing Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.NetworkLoadBalancing.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Remote Access Management Tools" capability (revert)
echo --- Remove "Remote Access Management Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.RemoteAccess.Management.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----Remove "Server Manager Tools" capability (revert)-----
:: ----------------------------------------------------------
echo --- Remove "Server Manager Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.ServerManager.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Remove "Shielded VM Tools" capability (revert)------
:: ----------------------------------------------------------
echo --- Remove "Shielded VM Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.Shielded.VM.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Storage Replica Module for Windows PowerShell" capability (revert)
echo --- Remove "Storage Replica Module for Windows PowerShell" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.StorageReplica.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Remove "Volume Activation Tools" capability (revert)---
:: ----------------------------------------------------------
echo --- Remove "Volume Activation Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.VolumeActivation.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Windows Server Update Services Tools" capability (revert)
echo --- Remove "Windows Server Update Services Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.WSUS.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Storage Migration Service Management Tools" capability (revert)
echo --- Remove "Storage Migration Service Management Tools" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.StorageMigrationService.Management.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Remove "Systems Insights Module for Windows PowerShell" capability (revert)
echo --- Remove "Systems Insights Module for Windows PowerShell" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Rsat.SystemInsights.Management.Tools*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -Remove "Windows Storage Management" capability (revert)--
:: ----------------------------------------------------------
echo --- Remove "Windows Storage Management" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Microsoft.Windows.StorageManagement*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -Remove "OneCore Storage Management" capability (revert)--
:: ----------------------------------------------------------
echo --- Remove "OneCore Storage Management" capability (revert)
PowerShell -ExecutionPolicy Unrestricted -Command "$capability = Get-WindowsCapability -Online -Name 'Microsoft.OneCore.StorageManagement*'; Add-WindowsCapability -Name "^""$capability.Name"^"" -Online"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0